package fr.asip.cps3.exemple.vues.menus;

import java.awt.event.ActionListener;
import fr.asip.cps3.exemple.modele.objets.Session;

/**
 * Classe modlisant un item de menu de type Session
 *
 */
public class ItemMenuSession extends ItemMenu {
	
	private static final long serialVersionUID = 7071214466348473372L;
	
	/**
	 * Session associe  l'item de menu
	 */
	private Session session;

	/**
	 * Constructeur  5 arguments
	 * @param session
	 * @param idParent Identifiant du menu parent
	 * @param bold Boolen de mise en forme "gras" de l'item de menu
	 * @param enable Boolen attestant du caractre actionnable de l'item de menu
	 * @param visible Boolen attestant du caractre visible de l'item de menu
	 * @param ecouteur Ecouteur positionn sur l'item de menu
	 */
	public ItemMenuSession(Session session,String idParent, boolean bold, boolean enable, boolean visible, ActionListener ecouteur) {
		
		super(idParent+",", idParent, "", bold, enable, visible, ecouteur);
		this.session = session;
		if(session != null) {
			setId(getIdParent()+","+session.getIdSession());
			setText(session.getLibelle());
		}
		
	}

	/**
	 * Accesseur
	 * @return Session associe  l'item de menu
	 */
	public Session getSession() {
		return session;
	}


	
}
